<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_History extends Minion_Task {

    protected $_options = array(
        'name'  => NULL
    );

    protected function _execute(array $params){
        $params = Helper::getConfigByName($params['name'], 'config_history');

        /* Check connection before continuing, if local searchd is down no need to bother storage */
        Database::instance('history_'.$params['database'])->connect();

        $fields = ['id', 'client_id', 'cid0', 'cid1', 'group', 'os_ver', 'data', 'source', 'created_at', 'opened_at'];
        $utc = new DateTimeZone("UTC");

        $records = DB::select()
            ->from('brow_history')
            ->where('id', '>', Helper::getCounter($params['name']))
            ->and_where('id', '<=', $params['limit'])
            ->order_by('id')
            ->limit(5000)
            ->execute('storage')
            ->as_array();

        /* Try multiple insert */
        if(!empty($records)) {
            $insert = DB::insert($params['name'], $fields);
            foreach ($records as $value) {
                $value = array_map('trim', $value);
                $value['source'] = self::sourceToInt($value['source']);
                $value['created_at'] = (new DateTime($value['created_at'], $utc))->getTimestamp();
                $value['opened_at'] = (new DateTime($value['opened_at'], $utc))->getTimestamp();
                $exp = explode('|', $value['data']);
                $value['data'] = $exp[0];
                $insert->values(Arr::extract($value, $fields));
            }

            try{
                $insert->execute('history_'.$params['database']);
            }catch (Exception $e){
                Minion_CLI::write(substr($e, 0, 500));
                $update = DB::select(DB::expr('max(id) AS max'))
                    ->from($params['name'])
                    ->where('id', '<', $params['limit'])
                    ->execute('history_'.$params['database'])
                    ->as_array();
                Helper::updCounter($update[0]['max'], $params['name']);
                exit;
            }

            /* Update counter */
            $value = end($records);
            Helper::updCounter($value['id'], $params['name']);
        }else{
            sleep(30);
        }
    }

    // todo write in model
    private static function sourceToInt($str){
        return array_search(strtolower(explode(' ', trim($str))[0]), array_map('strtolower', Kohana::$config->load('source')->as_array()));
    }
}